## Introduction
- NAT technology was developed to resolve IPv4 addressing issues due to the internet's expansion.
- Additional benefits include interconnecting networks with overlapping address spaces, useful during company mergers.
- Cisco Secure Firewall Threat Defense offers various NAT functionalities for address translations.

## NAT Functionality

##### IPv4 Address Translation
- Private networks use IPv4 addresses from RFC 1918, intended for local use.
- NAT translates private IPv4 addresses into public routable IPv4 addresses.
- Commonly, one address is assigned to the network for external communication, enhancing security.
##### Benefits of NAT

- Mitigates depletion of public IPv4 addresses via dynamic Port Address Translation (PAT).
- Allows using the same private IPv4 addresses in different networks.
- Preserves internal IP addressing plans when changing ISPs.
- Hides internal IP addressing and topology from external networks.

## NAT Categories

### Types of NAT Translation

- **Static NAT**: Maps a real IP address to a mapped IP address, useful for devices needing constant access.
- **Dynamic NAT**: Uses one-to-one mapping with IP addresses from a configured pool, borrowed temporarily.
- **Static PAT (Port Forwarding)**: Maps original host IP and service port to a mapped IP and port, useful for single public IP scenarios.
- **Dynamic PAT**: Many-to-one translation, allowing multiple internal hosts to use one public IP.

### Direction of NAT Translations

- **Inside NAT**: Translates IP addresses under control, affecting outgoing source IP and incoming destination IP.
- **Outside NAT**: Translates external IP addresses, useful for overlapping IP networks when only one side can perform NAT.

## Threat Defense NAT Implementation

### Configuration Types

- **Auto NAT**: Quick setup via network object parameters; rules are part of the command line object but not visible in object managers.
- **Manual NAT**: Allows configuration of real and mapped IP addresses in a single rule, supporting policy NAT and exceptions.

### NAT Rules Configuration

- **NAT Rules Before**: Manual NAT rules set by administrators, used for Twice NAT, Policy NAT, or exceptions.
- **Auto NAT Rules**: Simplified rules for Dynamic NAT or PAT and Static NAT.
- **NAT Rules After**: Catch-all scenario for unmatched traffic, using default translation rules.

## NAT Table and Rule Application

### Rule Evaluation Order

- Sections in NAT table read top-down until a match is found.
- **Section 1**: First match basis, specific rules before general ones.
- **Section 2**: Evaluates static then dynamic rules by quantity and address order.
- **Section 3**: General rules, ensuring specific rules precede applicable general ones.

